package com.example.possdkforandroid;

import java.io.UnsupportedEncodingException;

import com.example.possdkforandroid.BarCodeActivity.SpinnerSelectedListener;

import android.os.Bundle;
import android.app.Activity;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.Toast;
import android.widget.AdapterView.OnItemSelectedListener;

public class GS1CodeActivity extends Activity {
	
	//Parameter variable
	private String gs_data = null;
	private int DataLength = 0;
	private int BarcodeType = 0;
	private int BasicElementWidth = 0;
	private int BarcodeHeight = 0;
	private int BasicElementHeight = 0;
	private int SeparatorHeight = 0;
	private int SegmentHeight = 0;
	private int HRI_type = 0;
	private int AI_flag = 0;
	
	//Operate control
	private Button btnOK, btnRet;
	private EditText txtdata, txtBarHeight,txtSegmentheight;
	private Spinner gs_type_spi,gs_mode_width_spi,gs_basheight_spi,gs_sepheight_spi,gs_hri_type_spi,gs_ai_spi;
	
	//TestPrint variable
	private TestPrintInfo testprint;
	private int error_code = 0;
	
	//Returned Value Statement 
	public static final int POS_SUCCESS=1000;		//success
	public static final int ERR_PROCESSING = 1001;	//fail
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.gs1code);
       
        //************************************************************************************************
        //BarcodeType Spinner
        gs_type_spi = (Spinner)findViewById(R.id.gs_type_spi);
        String[] gs_type_items = {"GS1DataBar Omnidirectional","GS1DataBar Truncated","GS1 DataBar Stacked","GS1 DataBar Stacked Omnidirectiona","GS1 DataBar Limited","GS1 DataBar Expanded","GS1 DataBar ExpandedStacked"};
    	ArrayAdapter<String> adapter = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, gs_type_items);
    	adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
    	gs_type_spi.setAdapter(adapter);
    	
        //************************************************************************************************
        //BasicElementWidth Spinner
    	gs_mode_width_spi = (Spinner)findViewById(R.id.gs_mode_width_spi);
        String[] mode_width_items = {"1","2","3","4","5","6"};
    	adapter = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, mode_width_items);
    	adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
    	gs_mode_width_spi.setAdapter(adapter);
    	gs_mode_width_spi.setSelection(2);
    	
        //************************************************************************************************
        //BasicElementHeight Spinner 
    	gs_basheight_spi = (Spinner)findViewById(R.id.gs_basheight_spi);
        String[] basheight_items = {"1","2","3","4","5","6","7","8","9","10"};
    	adapter = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, basheight_items);
    	adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
    	gs_basheight_spi.setAdapter(adapter);
    	gs_basheight_spi.setSelection(1);
    	
        //************************************************************************************************
        //SeparatorHeight Spinner
    	gs_sepheight_spi = (Spinner)findViewById(R.id.gs_sepheight_spi);
        String[]sepheight_items = {"1","2","3","4","5","6","7","8","9","10"};
    	adapter = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, sepheight_items);
    	adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
    	gs_sepheight_spi.setAdapter(adapter);
        
        //************************************************************************************************
        //HRIFontType Spinner
    	gs_hri_type_spi = (Spinner)findViewById(R.id.gs_hri_type_spi);
        String[]hri_type_items = {"1","2","3","4"};
    	adapter = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, hri_type_items);
    	adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
    	gs_hri_type_spi.setAdapter(adapter);
    	
        //************************************************************************************************
        //AI Spinner
    	gs_ai_spi = (Spinner)findViewById(R.id.gs_ai_spi);
        String[]ai_items = {"0","1"};
    	adapter = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, ai_items);
    	adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
    	gs_ai_spi.setAdapter(adapter);
    	
    	//Get PrintData EditText Object
    	txtdata = (EditText)findViewById(R.id.gs_data);
    	
    	//Get BarcodeHeight EditText Object 
    	txtBarHeight = (EditText)findViewById(R.id.gs_bar_height);
    	
    	//Get SegmentHeight EditText Object
    	txtSegmentheight = (EditText)findViewById(R.id.gs_segmentheight);
    	
		//****************************************************************************************************
		//Get parameter and print
		btnOK = (Button)findViewById(R.id.gs_print_but);
		btnOK.setOnClickListener(new OnClickListener(){
			@Override
			public void onClick(View v) {
				String spi_str;
				int item;
				testprint = new TestPrintInfo();
				
				
				//Get PrintData
				gs_data = txtdata.getText().toString();
				
				//Get BarcodeType
				item = gs_type_spi.getSelectedItemPosition();
				BarcodeType = item+1;

				
				//Get BasicElementWidth
				spi_str = gs_mode_width_spi.getSelectedItem().toString();
				BasicElementWidth = Integer.parseInt(spi_str);
				
				//Get BarcodeHeight
				spi_str = txtBarHeight.getText().toString();
				if(spi_str.length() == 0){
					Toast.makeText(GS1CodeActivity.this, "Edit box value cannot be empty.",Toast.LENGTH_LONG).show();	
					return;
				}
				BarcodeHeight = Integer.parseInt(spi_str);
				
				//Get BasicElementHeight
				spi_str = gs_basheight_spi.getSelectedItem().toString();
				BasicElementHeight = Integer.parseInt(spi_str);
				
				//Get SeparatorHeight
				spi_str = gs_sepheight_spi.getSelectedItem().toString();
				SeparatorHeight = Integer.parseInt(spi_str);
				
				//Get SegmentHeight 
				spi_str = txtSegmentheight.getText().toString();
				if(spi_str.length() == 0){
					Toast.makeText(GS1CodeActivity.this, "Edit box value cannot be empty.",Toast.LENGTH_LONG).show();	
					return;
				}
				SegmentHeight = Integer.parseInt(spi_str);
				
				//Get HRIFontType
				spi_str = gs_hri_type_spi.getSelectedItem().toString();
				HRI_type = Integer.parseInt(spi_str);
				
				//Get AI Flag
				spi_str = gs_ai_spi.getSelectedItem().toString();
				AI_flag = Integer.parseInt(spi_str);
				
				//Get data length
				try {
					DataLength = gs_data.getBytes("GB18030").length;
				} catch (UnsupportedEncodingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				
				//USB
				if(MainActivity.port_type == MainActivity.USBPORT)
				{
					error_code = testprint.TestPrintGS1(USBActivity.pos_usb, USBActivity.printMode, gs_data, DataLength, 
							BarcodeType, BasicElementWidth, BarcodeHeight, BasicElementHeight, SeparatorHeight, SegmentHeight, HRI_type, AI_flag);
					if(error_code != POS_SUCCESS)
					{
						Toast.makeText(GS1CodeActivity.this, "Failed to print GS1BarCode.",Toast.LENGTH_LONG).show();
					}
				}
				//COM
				else if(MainActivity.port_type == MainActivity.SERIALPORT)
				{
					error_code = testprint.TestPrintGS1(SerialActivity.pos_com, SerialActivity.printMode, gs_data, DataLength, 
							BarcodeType, BasicElementWidth, BarcodeHeight, BasicElementHeight, SeparatorHeight, SegmentHeight, HRI_type, AI_flag);
					if(error_code != POS_SUCCESS)
					{
						Toast.makeText(GS1CodeActivity.this, "Failed to print GS1BarCode.",Toast.LENGTH_LONG).show();
					}
				}
				//WIFI
				else if(MainActivity.port_type == MainActivity.WIFIPORT)
				{
					error_code = testprint.TestPrintGS1(WIFIActivity.pos_wifi, WIFIActivity.printMode, gs_data, DataLength, 
							BarcodeType, BasicElementWidth, BarcodeHeight, BasicElementHeight, SeparatorHeight, SegmentHeight, HRI_type, AI_flag);
					if(error_code != POS_SUCCESS)
					{
						Toast.makeText(GS1CodeActivity.this, "Failed to print GS1BarCode.",Toast.LENGTH_LONG).show();
					}	
				}
				//Bluetooth
				else if(MainActivity.port_type == MainActivity.BLUETOOTHPORT)
				{
					error_code = testprint.TestPrintGS1(BlueActivity.pos_blue, BlueActivity.printMode, gs_data, DataLength, 
							BarcodeType, BasicElementWidth, BarcodeHeight, BasicElementHeight, SeparatorHeight, SegmentHeight, HRI_type, AI_flag);
					if(error_code != POS_SUCCESS)
					{
						Toast.makeText(GS1CodeActivity.this, "Failed to print GS1BarCode.",Toast.LENGTH_LONG).show();
					}	
				}
			   
			}});
		
		//*************************************************************************************************
		//Back
		btnRet = (Button)findViewById(R.id.gs_ret_but);
		btnRet.setOnClickListener(new OnClickListener(){
			@Override
			public void onClick(View v) {
				back();
			}
		});
    }
	private void back() {
		finish();
	}

}
